/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.GlobFilenameFilter;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;

public class FileUtilities {
    private static final String TRACE_MASKT = "XUTLFILT";
    private static final String TRACE_MASKF = "XUTLFILF";
    private static final String TRACE_MASKD = "XUTLFILD";

    public static void copy(String fileName1, String fileName2) throws FileNotFoundException, IOException {
        File filecheck;
        String path;
        File file2trim;
        String goodFileName1 = null;
        goodFileName1 = fileName1.endsWith("/") ? fileName1.substring(0, fileName1.lastIndexOf("/")) : fileName1;
        File file1 = new File(goodFileName1);
        String goodFileName2 = null;
        goodFileName2 = fileName2.endsWith("/") ? ((file2trim = new File(path = fileName2.substring(0, fileName2.lastIndexOf("/")))).isDirectory() ? fileName2 + file1.getName() : path) : ((filecheck = new File(fileName2)).isDirectory() ? fileName2 + "/" + file1.getName() : fileName2);
        File file2 = new File(goodFileName2);
        FileUtilities.copy(file1, file2);
    }

    public static void copy(File file1, File file2) throws FileNotFoundException, IOException {
        if (!file1.exists()) {
            throw new FileNotFoundException();
        }
        if (file1.isDirectory()) {
            try {
                FileUtilities.copyDirectory(file1, file2);
            }
            catch (IOException ioexc) {
                System.out.println("exception in copying directory: " + ioexc.getMessage());
                throw new IOException(ioexc.getMessage());
            }
        }
        FileInputStream file1Input = new FileInputStream(file1);
        BufferedInputStream bufFile1Input = new BufferedInputStream(file1Input, 8192);
        if (file2.exists() && file2.isDirectory()) {
            String file2Name = file2.getAbsolutePath() + "/" + file1.getName();
            file2 = new File(file2Name);
        } else if (file2.exists()) {
            file2.delete();
        }
        FileOutputStream file2Output = new FileOutputStream(file2);
        BufferedOutputStream bufFile2Output = new BufferedOutputStream(file2Output, 8192);
        byte[] buffer = new byte[8192];
        int bytesRead = bufFile1Input.read(buffer);
        while (bytesRead != -1) {
            bufFile2Output.write(buffer, 0, bytesRead);
            bytesRead = bufFile1Input.read(buffer);
        }
        try {
            bufFile1Input.close();
            bufFile2Output.flush();
            bufFile2Output.close();
        }
        catch (IOException ioexc) {
            bufFile2Output.close();
            throw ioexc;
        }
    }

    public static void copyAll(String fileName) throws FileNotFoundException, IOException, IllegalArgumentException {
        Trace.trace(TRACE_MASKF, "copyAll(), fileName is " + fileName);
        Properties properties = new Properties();
        properties.load(new FileInputStream(fileName));
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String sourceFileName = (String)e.nextElement();
            String targetFileName = (String)properties.get(sourceFileName);
            Trace.trace(TRACE_MASKF, "copy file " + sourceFileName + " to " + targetFileName);
            FileUtilities.copy(sourceFileName, targetFileName);
        }
    }

    private static void copyDirectory(File file1, File file2) throws IOException {
        String fileName2;
        if (file2.exists() && !file2.isDirectory()) {
            throw new IOException("cannot copy a directory into a file");
        }
        if (file1.getAbsolutePath().equals(file2.getAbsolutePath())) {
            throw new IOException("cannot copy a directory onto itself");
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if ((fileName2 = file2.getAbsolutePath()).endsWith("/")) {
            fileName2 = fileName2 + file1.getName();
        } else if (!file1.getName().equals(file2.getName())) {
            fileName2 = fileName2 + "/" + file1.getName();
        }
        File file3 = new File(fileName2);
        if (file3.exists() && !file3.isDirectory()) {
            throw new IOException("cannot copy directory into file");
        }
        if (!file3.exists()) {
            file3.mkdir();
        }
        String[] files = file1.list();
        for (int i = 0; i < files.length; ++i) {
            String fileToCopy = file1.getAbsolutePath() + "/" + files[i];
            FileUtilities.copy(fileToCopy, fileName2);
        }
    }

    public static void move(String fileName1, String fileName2) throws FileNotFoundException, IOException {
        FileUtilities.copy(fileName1, fileName2);
        FileUtilities.delete(fileName1);
    }

    public static void move(File file1, File file2) throws FileNotFoundException, IOException {
        FileUtilities.copy(file1, file2);
        FileUtilities.delete(file1);
    }

    public static void delete(String fileName1) throws FileNotFoundException, IOException {
        String goodFileName1 = null;
        goodFileName1 = fileName1.endsWith("/") ? fileName1.substring(0, fileName1.lastIndexOf("/")) : fileName1;
        File file1 = new File(goodFileName1);
        FileUtilities.delete(file1);
    }

    public static void delete(File file1) throws FileNotFoundException, IOException {
        if (!file1.exists()) {
            throw new FileNotFoundException();
        }
        if (file1.isDirectory()) {
            try {
                FileUtilities.deleteDirectory(file1);
            }
            catch (IOException ioexc) {
                throw new IOException(ioexc.getMessage());
            }
        } else {
            file1.delete();
        }
    }

    private static void deleteDirectory(File file1) throws IOException {
        File[] files = file1.listFiles();
        for (int i = 0; i < files.length; ++i) {
            FileUtilities.delete(files[i]);
        }
        file1.delete();
    }

    public static ArrayList getDirList(String dirPath) throws HException {
        File dirFile = new File(dirPath);
        if (!dirFile.exists()) {
            Trace.trace(TRACE_MASKT, "getDirList: directory '" + dirPath + "' not found");
            throw new HException(new FileNotFoundException("directory '" + dirPath + "' not found"));
        }
        ArrayList<String> list = new ArrayList<String>();
        Object[] files = dirFile.listFiles();
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (!((File)files[i]).isDirectory()) continue;
            Trace.trace(TRACE_MASKD, "getDirList: adding directory '" + ((File)files[i]).getName() + "'...");
            list.add(dirPath + ((File)files[i]).getName());
        }
        return list;
    }

    public static ArrayList getFileList(String dirPath, String criteria, boolean wholeMatch) throws HException {
        File dirFile = new File(dirPath);
        if (!dirFile.exists()) {
            Trace.trace(TRACE_MASKT, "getFileList: directory '" + dirPath + "' not found");
            throw new HException(new FileNotFoundException("directory '" + dirPath + "' not found"));
        }
        ArrayList<String> list = new ArrayList<String>();
        Object[] files = dirFile.listFiles(new GlobFilenameFilter(criteria, wholeMatch));
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (!((File)files[i]).isFile()) continue;
            list.add(((File)files[i]).getName());
        }
        return list;
    }

    public static ArrayList getFileList(String dirPath) throws HException {
        return FileUtilities.getFileList(dirPath, "*", false);
    }
}

